/* definition of id in back_bone */
#define	dd_type		0x40
#define	dv_type		0x20
#define	dv_flag		0x21
#define	header_type	0x10


struct	call_table {
	char	req_id[2];
	unsigned char	flags[2];
	unsigned char	PicVer[2];
	struct
	{
		unsigned char : 6;
		unsigned char Protocol		: 1;	/* 0: room  1: DPlus */
		unsigned char RepeaterAcc	: 1;
	} flag;                            // Flag structure
	char	reserve;
	char	callsign[8];
	char	zone[8];
	char	area[8];
	DWORD 	ip_address;
	int		ssn;
	int		port;
};

struct	connected_table {
	struct connected_table *f_chain;
	char	callsign[8];
	char	roomname[8];
	char	LastCallsign[8];
	DWORD	ip_address;
	UDP_SOCKET	SendSocket;
	int	port;
	struct
	{
		unsigned char : 6;
		unsigned char alive			: 1;
		unsigned char RepeaterAcc	: 1;
	} flag;                            // Flag structure
};

struct	dv_header{
	unsigned char	flags[3];
	unsigned char	RPT2Call[8];
	unsigned char	RPT1Call[8];
	unsigned char	YourCall[8];
	unsigned char	MyCall[8];
	unsigned char	MyCall2[4];
	unsigned char	CRC[2];
};

struct	back_bone{
	unsigned char	id;
	unsigned char	dest_repeater_id;
	unsigned char	send_repeater_id;
	unsigned char	send_terminal_id;
	unsigned char	seq_high;
	unsigned char	seq_low;
	unsigned char	control;
};

struct	voice_data{
	unsigned char	voice_segment[9];
	unsigned char	data_segment[3];
};

struct inet_dv_packet {
	unsigned char	id[4];
	unsigned char	flags[2];
	unsigned char	reserve[2];
	struct	back_bone b_bone;
	union {
		struct	dv_header rf_header;
		struct	voice_data v_data;
	};
};


struct node_packet {
	union {
		struct inet_dv_packet node_dv_pkt;
		struct call_table node_table;
	};
};

struct	connect_log {
	unsigned char	NodeCall[8];
	unsigned char	RoomName[8];
	DWORD			ip_address;
	unsigned char	reserve[4];
};
	
struct	access_log {
	unsigned char	NodeCall[8];
	unsigned char	RoomName[8];
	unsigned char	MyCall[8];
};

struct	node_log{
	unsigned char	id[4];
	unsigned char	reserve[4];
	union {
		struct connect_log con_log;
		struct access_log acc_log;
	};
};


#define ROOM_SERVER_IN_PORT			(39999)
#define ROOM_SERVER_OUT_PORT		(39998)
#define ROOM_SERVER_LOG_PORT		(39997)
#define ROOM_SERVER_DPLUS_PORT		(20001)
